//
//  GHActivityData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 10/31/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GHLapData.h"
#import "GHSetData.h"

/**
 *  The GHActivityData class provides detailed information about User initiated activities. 
 */
@interface GHActivityData : NSObject <NSCoding>


/** Name of the sport. Can be null. */
@property (nullable, nonatomic, readonly) NSString *sport;

/** Name of the subSport.*/
@property (nullable, nonatomic, readonly) NSString *subSport;

/** Type of the sport.*/
@property (nullable, nonatomic, readonly) NSString *sportType;

/** Latitude in degrees for the start of the activity. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *startLatitude;

/** Longitude in degrees for the start of the activity. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *startLongitude;

/** Latitude in degrees for the end of the activity. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *endLatitude;

/** Longitude in degrees for the end of the activity. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *endLongitude;

/** Starting time of the activity. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *startTime;

/** Elapsed time in seconds. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *elapsedTime;

/** Distance covered in meters. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *distance;

/** Calories burned. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *calories;

/** Average speed in meters per second (m/s). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *averageSpeed;

/** Maximum speed in meters per second (m/s). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *maximumSpeed;

/** Average heart rate in beats per minute (BPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *averageHeartRate;

/** Maximum heart rate in beats per minute (BPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *maximumHeartRate;

/** Average cadence in revolutions per minute (RPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *averageCadence;

/** Maximum cadence in revolutions per minute (RPM). Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *maximumCadence;

/**
 *  Array of laps for the activity. Refer to
 *  GHLapData for additional details about the data.
 */
@property (nullable, nonatomic, readonly) NSArray<GHLapData *> *lapsArray;

/**
 *  Array of sets for the activity. Refer to
 *  GHSetData for additional details about the data.
 */
@property (nullable, nonatomic, readonly) NSArray<GHSetData *> *setsArray;


@end
